function [a2b,b2a,ab] = unique_verts(a,b)
%This function takes two lists of vertices and finds the vertices in each
%that is unique
%Synatax:   [a2b,b2a,ab] = unique_verts(a,b);
%Input:     a = vertices list a(Note: only care about the first 3 points,
%               in a vert array
%           b = vertices list b
%
%Output:    a2b = unique verts in a
%           b2a = unique verts in b
%           ab = not unique verts, a cell array, with 2 cells. Cell 1 is an
%               array with a2b not unique, and the sceond is b2a not unique,
%               the vertices should be the same.

%make the arrays smaller to work with
a = single(a);
b = single(b);

%find the unique verts in a
a_cube = repmat(a(:,1:3),[1 1 size(b,1)]);      %vectorize the calculation make to same sized matrices
b_cube = permute(b(:,1:3),[3 2 1]);       %reshape the b array into z
b_cube = repmat(b_cube,[size(a,1),1,1]);        %cubify the b variable
%look for identify along all axis
a_idx = a_cube==b_cube;         %a logical matrix is created
a_idx = prod(single(a_idx),2);  %now we know which vertices have a match
a_idx = logical(max(a_idx,[],3));        %create the index
%now create the unique array
a2b = a(~a_idx,:);         %unique a vertices
ab{1,1} = sortrows(a(a_idx,:));         %not unique, should be the same as b
%clean up
clear a_cube b_cube

%find the unique verts in b
%find the unique verts in a
b_cube = repmat(b(:,1:3),[1 1 size(a,1)]);      %vectorize the calculation make to same sized matrices
a_cube = permute(a(:,1:3),[3 2 1]);       %reshape the b array into z
a_cube = repmat(a_cube,[size(b,1),1,1]);        %cubify the b variable
%look for identify along all axis
b_idx = b_cube==a_cube;         %a logical matrix is created
b_idx = prod(single(b_idx),2);  %now we know which vertices have a match
b_idx = logical(max(b_idx,[],3));        %create the index
%now create the unique array
b2a = b(~b_idx,:);         %unique a vertices
ab{1,2} = sortrows(b(b_idx,:));         %not unique, should be the same as 